%%%%%%%%%
% app.m %
%%%%%%%%%

terminate(pyenv);
clearvars;

% Read data file
data = readBioData('https://git.io/J2B8A');

component = dashBio('AlignmentChart', {...
        'id', 'alignment-viewer-eventDatum-usage',...
        'data', data});

divHtml = Html('Div', {'id', 'alignment-viewer-eventDatum-usage-output',...
    'style', struct('whiteSpace','pre-line')});

components = {component, divHtml};

% Callbacks
args = {...
    argsOut('alignment-viewer-eventDatum-usage-output', 'children'),...
    argsIn('alignment-viewer-eventDatum-usage', 'eventDatum')};
handle = 'update_output';
callbackDat = {args, handle};

% Run the app
startDash(components, 8057, callbackDat);

%%%%%%%%%%%%%%%%%%%
% update_output.m %
%%%%%%%%%%%%%%%%%%%

function out = update_output(value)
    if strcmp(value, "NaN")
        out = jsonencode({sprintf('No data.')});
    else
        out = jsonencode({string(value)});
    end
end
