using JSON3, DashVtk, DashHtmlComponents, Dash

filepath = download("https://github.com/plotly/dash-vtk/blob/master/demos/data/cow-nonormals.obj");
txt_content = read(filepath, String);

view = vtk_view(
    id="click-info-view",
    pickingModes=["click"],
    children=[
        vtk_geometryrepresentation(id="cow-geometry", children=[
            vtk_reader(
                vtkClass="vtkOBJReader",
                parseAsText=txt_content,
            ),
        ]),
    ],
);

# Dash setup
app = dash()

app.layout = html_div([
    html_div(view, style=Dict("width" => "100%", "height" => "300px")),
    html_b("Output of clickInfo (try clicking on the object above):"),
    html_pre(
        id="click-info-output",
        style=Dict("overflowX" => "scroll")
    )
]);

# Dash setup
app = dash()

callback!(
    app,
    Output("click-info-output", "children"),
    Input("click-info-view", "clickInfo")
) do click_info
    return JSON3(click_info, indent=2)
end

run_server(app, "0.0.0.0", debug = true)
