using Dash

external_stylesheets = ["https://codepen.io/chriddyp/pen/bWLwgP.css"]

app = dash(external_stylesheets=external_stylesheets)

app.layout = html_div([
    html_h1("Dash Tabs component demo"),
    dcc_tabs(id="tabs-example-graph", value="tab-1-example-graph", children=[
        dcc_tab(label="Tab One", value="tab-1-example-graph"),
        dcc_tab(label="Tab Two", value="tab-2-example-graph"),
    ]),
    html_div(id="tabs-content-example-graph")
])

callback!(app,
    Output("tabs-content-example-graph", "children"),
    Input("tabs-example-graph", "value")
) do tab
    if tab == "tab-1-example-graph"
        return html_div([
            html_h3("Tab content 1"),
            dcc_graph(
                id="graph-1-tabs",
                figure=Dict(
                    "data" =>  [Dict(
                        "x" =>  [1, 2, 3],
                        "y" =>  [3, 1, 2],
                        "type" =>  "bar"
                    )]
                )
            )
        ])
    elseif tab == "tab-2-example-graph"
        return html_div([
            html_h3("Tab content 2"),
            dcc_graph(
                id="graph-2-tabs",
                figure=Dict(
                    "data" =>  [Dict(
                        "x" =>  [1, 2, 3],
                        "y" =>  [5, 10, 6],
                        "type" =>  "bar"
                    )]
                )
            )
        ])
    end
end

run_server(app, "0.0.0.0", debug=true)