using Dash, DashBio, DashBioUtils
using StringEncodings, HTTP, JSON

external_stylesheets = ["https://codepen.io/chriddyp/pen/bWLwgP.css"]

data = "https://git.io/speck_methane.xyz"

data = DashBioUtils.read_xyz(data, is_datafile=false)

app = dash(external_stylesheets=external_stylesheets)

app.layout = html_div([
  dcc_dropdown(
      id="default-speck-preset-views",
      options=[
          Dict("label" =>  "Default", "value" =>  "default"),
          Dict("label" =>  "Ball and stick", "value" =>  "stickball")
      ],
      value="default"
  ),
  dashbio_speck(
      id="default-speck",
      data=data
  ),
])

callback!(app,
  Output("default-speck", "presetView"),
  [Input("default-speck-preset-views", "value")]
) do preset_name
  return preset_name
end

run_server(app, "0.0.0.0", debug=true)
