using Dash 
using OrderedCollections, DataFrames   

data = OrderedDict(
      "Date" => ["2015-01-01", "2015-10-24", "2016-05-10", "2017-01-10", "2018-05-10", "2018-08-15"],
      "Region" => ["Montreal", "Toronto", "New York City", "Miami", "San Francisco", "London"],
      "Temperature" => [1, -20, 3.512, 4, 10423, -441.2],
      "Humidity" => [10, 20, 30, 40, 50, 60],
      "Pressure" => [2, 10924, 3912, -10, 3591.2, 15],
)

df = DataFrame(data) 

app = dash()

app.layout = dash_datatable(
    data = map(eachrow(df)) do r
      Dict(names(r) .=> values(r))
    end,
    columns=[Dict("name" =>c, "id" => c) for c in names(df)],
    style_data=Dict( "border" =>  "1px solid blue" ),
    style_header=Dict( "border" =>  "1px solid pink" ),
    
)

run_server(app, "0.0.0.0", debug=true)