using Dash

using DataFrames   

data_with_none = [
    Dict("Firm" =>  "Acme", "2017" =>  "", "2018" =>  5, "2019" =>  10, "2020" =>  4),
    Dict("Firm" =>  "Olive", "2017" =>  nothing, "2018" =>  3, "2019" =>  13, "2020" =>  3),
    Dict("Firm" =>  "Barnwood", "2017" =>  NaN, "2018" =>  7, "2019" =>  3, "2020" =>  6),
    Dict("Firm" =>  "Henrietta", "2017" =>  14, "2018" =>  1, "2019" =>  13, "2020" =>  1),
]

df = vcat(DataFrame.(data_with_none)...)

app = dash()

app.layout = html_div([
  html_pre(string(df)),
  dash_datatable(
      data=Dict.(pairs.(eachrow(df))),
      columns=[
            Dict(
                "name" =>  i,
                "id" =>  i,
                "type" =>  "numeric",
                "format" =>  Format(
                    nully="N/A"
                )
            ) for i in names(df)
        ],
        editable=true
  )
])

run_server(app, "0.0.0.0", debug=true)

