using Dash

app = dash()

app.layout = html_div([
    dcc_tabs(id="tabs-styled-with-props", value="tab-1", children=[
        dcc_tab(label="1", value="tab-1"),
        dcc_tab(label="2", value="tab-2"),
    ], colors=Dict(
        "border" =>  "white",
        "primary" =>  "gold",
        "background" =>  "cornsilk"
    )),
    html_div(id="tabs-content-props-4")
])

callback!(app,
    Output("tabs-content-props-4", "children"),
    Input("tabs-styled-with-props", "value")
) do tab
    if tab == "tab-1"
        return html_div([
            html_h3("Tab content 1")
        ])
    elseif tab == "tab-2"
        return html_div([
            html_h3("Tab content 2")
        ])
    end
end

run_server(app, "0.0.0.0", debug=true)
