using Dash

app = dash()

app.layout = html_div(
    children=[
        html_h3("Edit text input to see loading state"),
        dcc_input(id="loading-input-1", value="Input triggers local spinner"),
        dcc_loading(
            id="loading-1",
            type="default",
            children=html_div(id="loading-output-1")
        ),
        html_div(
            [
                dcc_input(id="loading-input-2", value="Input triggers nested spinner"),
                dcc_loading(
                    id="loading-2",
                    children=[html_div([html_div(id="loading-output-2")])],
                    type="circle",
                )
            ]
        ),
    ],
)

callback!(app,
    Output("loading-output-1", "children"), 
    Input("loading-input-1", "value")
) do value
    sleep(1)
    return value
end

callback!(app,
    Output("loading-output-2", "children"), 
    Input("loading-input-2", "value")
) do value
    sleep(1)
    return value
end

run_server(app, "0.0.0.0", debug=true)
