---
url: /dash-core-components/datepickersingle
name: DatePickerSingle
description:
    "The dcc.DatePickerSingle component helps users select a date, either by entering text or choosing on a calendar."
languages:
    - python
    - julia
    - fsharp
---

# ![](/assets/images/language_icons/julia_50px.svg) dcc.DatePickerSingle

`dcc.DatePickerSingle` is a component for rendering a calendar from which the user can select a date.

. `{{component dcc.DatePickerSingle` accepts dates with a time part, but this can be confusing, particularly for the initial call of a callback. After the user chooses a new date, there will be no time part&mdash;only the date. If you already have a }}`DateTime` object, you can convert it with `Date()`. 

## Month and Display Format

The  property determines how calendar headers are displayed when the calendar is opened.
The  property determines how selected dates are displayed in the `dcc.DatePickerSingle` component.

Both of these properties are configured through strings that use a combination of any of the following tokens.

| String Token | Example          | Description                                            |
|--------------|------------------|--------------------------------------------------------|
| `YYYY`       | `2014`           | 4 or 2 digit year                                      |
| `YY`         | `14`             | 2 digit year                                           |
| `Y`          | `-25`            | Year with any number of digits and sign                |
| `Q`          | `1..4`           | Quarter of year. Sets month to first month in quarter. |
| `M MM`       | `1..12`          | Month number                                           |
| `MMM MMMM `  | `Jan..December`  | Month name                                             |
| `D DD`       | `1..31 `         | Day of month                                           |
| Do           | `1st..31st`      | Day of month with ordinal                              |
| `DDD DDDD`   | `1..365 `        | Day of year                                            |
| `X`          | `1410715640.579` | Unix timestamp                                         |
| `x`          | `1410715640579`  | Unix ms timestamp                                      |


## Examples

Find a few usage examples below.

### Simple DatePickerSingle Example

This is a simple example of a `dcc.DatePickerSingle` component tied to a callback.

The  properties define the minimum and maximum selectable dates on the calendar while  defines the calendar month that is first displayed when the `dcc.DatePickerSingle` component is opened.

{{example simple_datepicker}}

### Month Format Examples

You can set  to any permutation of the string tokens shown in **Month and Display Format** above to change how calendar titles are displayed in the `dcc.DatePickerSingle` component.

{{example datepicker_MMM_format_month}}
{{example datepicker_MDYQ_format_month}}
{{example datepicker_MMMMYDD_format_month}}
{{example datepicker_x_format_month}}

### Display Format Examples

You can use any permutation of the string tokens shown in **Month and Display Format** above to change how selected dates are displayed in the `dcc.DatePickerSingle` component.

{{example datepicker_MMM_format}}
{{example datepicker_MDYQ_format}}
{{example datepicker_MMMMYDD_format}}
{{example datepicker_x_format}}

### Vertical Calendar and Placeholder Text

The `dcc.DatePickerSingle` component can be rendered in two orientations, either horizontally or vertically. If  is set to , it will be rendered vertically and will default to  if not defined.

The `placeholder` defines the grey default text defined in the calendar input boxes when no date is selected.

{{example datepicker_vertical}}

### Calendar Clear and Portals

When the `clearable` property is set to `true` the component will be rendered with a small `x` that will remove all selected dates when selected.

The `dcc.DatePickerSingle` component supports two different portal types, one being a full screen portal () and another being a simple screen overlay, like the one shown below ().

{{example datepicker_clearable}}

### Right To Left Calendars and First Day of Week

When the  property is set to `true` the calendar will be rendered from right to left.

The  property allows you to define which day of the week will be set as the first day of the week. In the example below, Tuesday is the first day of the week.

{{example datepicker_rtl}}

------------------------

{{reference dcc.DatePickerSingle}}
