using Dash, DashBio, DashBioUtils

app = dash()

data_path = "https://raw.githubusercontent.com/plotly/datasets/master/Dash_Bio/Molecular/"


app.layout = html_div([
    dcc_slider(id="height-ngl-h", min=300, max=800, value=600,step=100, marks=Dict(300 => "300px",800 => "800px")),
    dcc_slider(id="width-ngl-w", min=300, max=800, value=600,step=100, marks=Dict(300 => "300px", 800 => "800px")),
    dashbio_nglmoleculeviewer(id="dimensions-ngl-hw"),
])

callback!(app,
    [Output("dimensions-ngl-hw", "data"),
     Output("dimensions-ngl-hw", "molStyles"),
     Output("dimensions-ngl-hw", "height"),
     Output("dimensions-ngl-hw", "width")],
    [Input("height-ngl-h", "value"),
     Input("width-ngl-w", "value")]) do height, width

      molstyles_dict = Dict(
            "representations" => ["cartoon", "axes+box"],
            "chosenAtomsColor" => "red",
            "chosenAtomsRadius" => 1,
            "molSpacingXaxis" => 100,
        )
    data_list = [DashBioUtils.get_data(data_path, "1BNA", "red", reset_view=true, loc=false)]

    return data_list, molstyles_dict, height, width

end

run_server(app, "0.0.0.0", debug=true)