---
url: /installation
name: Installation
description:
    "How to install and upgrade Dash"
icon: tools.svg
languages:
  - python
  - r
  - fsharp
  - matlab
  - julia
---
# ![](/assets/images/language_icons/julia_50px.svg) Dash Installation



In your Julia REPL, install `Dash` and other supporting packages

```
pkg> add Dash
```
To install the latest (stable) development version of Dash instead:
```
using Pkg;
Pkg.add(PackageSpec(url="https://github.com/plotly/Dash.jl.git", rev="dev"))
```
A quick note on checking your versions and on upgrading. These docs are run using the versions listed above and these versions should be the latest versions available. To check which version that you have installed, you can run:
```
Pkg.status("Dash")
```
To see the latest changes of any package, check the CHANGELOG.MD file in the appropriate GitHub repo.

This also brings along the `Plotly` graphing
library. This library is
under active development, so install and upgrade frequently.








These docs are running `Dash` version ` ||julia `1.0.0` ||r `0.9.1`}}.

This version supports Julia 1.2 or higher.



{{oss {{dash-club}} }}



{{oss
{{import /reusable_components/WorkspaceBlurb.md}}
}}
