---
url: /layout
name: Part 1. Layout
description:
    "The Dash `layout` describes what your app will look like and is composed
    of a set of declarative Dash components."
icon: layout.svg
languages:
  - python
  - julia
  - r
  - fsharp
  - matlab
---

# ![](/assets/images/language_icons/julia_50px.svg) Dash Layout

<blockquote>
This is the 1st chapter of the <dccLink children="Dash Fundamentals" href="/"/>.
The <dccLink href="/basic-callbacks" children="next chapter"/> covers Dash callbacks.
</blockquote>

This tutorial will walk you through a fundamental aspect of Dash apps, the
app `layout`, through six self-contained apps.

For production Dash apps, we recommend styling the app `layout` with
{{de Dash Enterprise <dccLink href="/dash-design-kit" children="Design Kit"/>.||oss Dash Enterprise [Design Kit](https://plotly.com/dash/design-kit/).}}

***

Dash apps are composed of two parts. The first part is the "`layout`", which describes what the app looks like.
The second part describes the interactivity of the app and will be
covered in the <dccLink href="/basic-callbacks" children="next chapter"/>.

Note: Throughout this documentation,

 Julia
code examples are meant to be saved as files and executed
using `julia app.jl`
 You can also use Jupyter with the [JupyterDash](https://github.com/plotly/jupyter-dash) library.

{{oss
> If you're using Dash Enterprise's [Data Science Workspaces](https://plotly.com/dash/workspaces/),
> copy & paste the below code into your Workspace ([see video](https://plotly.com/dash/workspaces/#screencast)).

> _[Find out if your company is using Dash Enterprise](https://plotly.com/company-lookup/)_
}}

To get started, create a file named
`app.jl`
, copy the code below into it, and then run it
 with `julia app.jl`.

{{example getting_started_layout_1}}

```bash
$ julia app.jl
[ Info: Listening on: 0.0.0.0:8050
```

Visit [http://127.0.0.1:8050/](http://127.0.0.1:8050/)
 in your web browser. You should see an app that looks like the one above.

Note:

1. The `layout` is composed of a tree of "components" such as
   `html_div`
    and `dcc_graph`.
2. The `DashHtmlComponents`
   function
    has a component for every HTML tag.
   The `html_h1("Hello Dash")`
    component generates a `<h1>Hello Dash</h1>` HTML element in your app.
3. Not all components are pure HTML.
   `DashCoreComponents`
   describe higher-level components that are interactive and are generated with
    JavaScript, HTML, and CSS through the React.js library.

4. Each component is described entirely through keyword attributes.
    Dash is _declarative_: you will primarily describe your app
    through these attributes.
5. The `children` property is special. By convention, it's always the first attribute {{python
which means that you can omit it: `html.H1(children='Hello Dash')` is the same as `html.H1('Hello Dash')`which means that you can omit it: `html_h1(children="Hello Dash")` is the same as `html_h1("Hello Dash")`. It  can contain a string, a number, a single component, or a list of components.
||r 5. For pure HTML components, any named argument becomes an attribute on the HTML tag, while any unnamed argument becomes a child. For example, `div(id = "name", "Joe")` results in `<div id="name">Joe</div>`.}}
6. The fonts in your app will look a little bit different than what is displayed here.
   This app is using a custom CSS stylesheet and {{de Dash Enterprise <dccLink href="/dash-design-kit" children="Design Kit"/>||oss Dash Enterprise [Design Kit](https://plotly.com/dash/design-kit/)}}
    to modify the default styles of the elements. You can learn more about custom CSS in the
    <dccLink href="/external-resources" children="CSS tutorial"/>.




### Making Your First Change

Dash includes "hot-reloading". This feature is activated by default when
you run your app with `run_server(app, "0.0.0.0", debug=true)`.
This means that Dash
will automatically refresh your browser when you make a change in your code.

Give it a try: change the title "Hello Dash" in your app or change the
`x` or the `y` data. Your app should auto-refresh with your change.

> Don't like hot-reloading? You can turn this off with `run_server(app, "0.0.0.0", debug=true, dev_tools_hot_reload=false)`.
> Learn more in <dccLink href="/devtools" children="Dash Dev Tools documentation"/>
> Questions? See the [community forum hot reloading discussion](https://community.plotly.com/t/announcing-hot-reload/14177).


{{oss {{dash-club}} }}
### More about HTML Components

`DashHtmlComponents`
contains a component class for every HTML tag as well as keyword arguments for all of the HTML arguments.



Let's customize the text in our app by modifying the inline styles of the components.
 Create a file named `app.jl` with the following code:

{{example getting_started_layout_2}}

In this example, we modified the inline styles of the
 `html_div`
and `html_h1`components with the `{{fsharp Attr.  style` property}}.

```julia
html_h1(
    "Hello Dash",
    style = Dict("color" => "#7FDBFF", "textAlign" => "center"),
)
```

The above code is rendered in the Dash app as
`<h1 style="text-align: center; color: #7FDBFF">Hello Dash</h1>`.

There are a few important differences between the `DashHtmlComponents`
and the HTML attributes:

1. The `style` property in HTML is a semicolon-separated string. In Dash,
   you can just supply a dictionary.
2. The keys in the `style` dictionary are [camelCased](https://en.wikipedia.org/wiki/Camel_case).
   So, instead of `text-align`, it's `textAlign`.
3. The HTML `class` attribute is `className` in Dash.
4. The children of the HTML tag is specified through the `children` keyword
   argument. By convention, this is always the _first_ argument {{python|julia|matlab and so it is often omitted.
||r 4. The HTML `for` attribute is `htmlFor` in Dash.
}}


Besides that, all of the available HTML attributes and tags are available
to you within your Julia context.



***

### Reusable Components

By writing our markup in Julia, we can create complex reusable components like tables without switching contexts or languages.

Here's a quick example that generates a `Table` from a
 DataFrame. Create a file named `app.jl` with the following code:

{{example getting_started_table}}



### More about Visualization

The `DashCoreComponents`
 library includes a component called
 `dcc_graph`.

`dcc_graph`
 renders interactive data visualizations using the open source
[plotly.js](https://github.com/plotly/plotly.js) JavaScript graphing
library. Plotly.js supports over 35 chart types and renders charts in
both vector-quality SVG and high-performance WebGL.

The `figure` argument in the `dcc_graph`
 component is the same `figure` argument that is used by `plotly.py`, Plotly's
open source Julia graphing library.
Check out the [plotly.py documentation and gallery](https://plotly.com/python)
to learn more.

Here's an example that creates a scatter plot from a
 DataFrame. Create a file named `app.jl` with the following code:

{{example getting_started_viz}}

*These graphs are interactive and responsive.
 **Hover** over points to see their values,
 **click** on legend items to toggle traces,
 **click and drag** to zoom,
 **hold down shift, and click and drag** to pan.*


### Markdown

While Dash exposes HTML through `DashHtmlComponents`, it can be tedious to write your copy in HTML.  For writing blocks of text, you can use the
`dcc_markdown` component in
`DashCoreComponents`. Create a file named `app.jl` with the following code:

{{example getting_started_markdown}}

### Core Components

`DashCoreComponents`
 includes a set of higher-level components like dropdowns, graphs, markdown blocks, and more.

Like all Dash components, they are described entirely declaratively.
Every option that is configurable is available as a keyword argument
of the component.

We'll see many of these components throughout the tutorial.
You can view all of the available components in the
<dccLink href="/dash-core-components" children="Dash Core Components overview"/>.

Here are a few of the available components.
Create a file named `app.jl` with the following code:

{{example getting_started_core_components}}

### Help

Dash components are declarative: every configurable aspect of these
components is set during instantiation as a keyword argument.

Call `?` in your Julia REPL  on any of the components to
learn more about a component and its available arguments.

```julia
  help?> dcc_dropdown

  dcc_dropdown(;kwargs...)

  | A Dropdown component.
  | Dropdown is an interactive dropdown element for selecting one or more
  | items.
  | The values and labels of the dropdown items are specified in the `options`
  | property and the selected item(s)
  | are specified with the `value` property.
  | Use a dropdown when you have many options (more than 5) or when you are
  | constrained for space. Otherwise, you can use RadioItems or a Checklist,
  | which have the benefit of showing the users all of the items at once.

  | Keyword arguments:
  | - id (String; optional)
  | - className (String; optional)
  | - disabled (Bool; optional): If true, this dropdown is disabled
  | - multi (Bool; optional): If true, the user can select multiple values
  | - options (optional)
  | - placeholder (String; optional): The grey, default text shown when no option is selected
  | - value (String | Real | Array of String | Reals; optional): The value of the
  | input. If `multi` is false (the default)then value is just a string that
  | corresponds to the values provided in the `options` property. If `multi` is true,
  | then multiple values can be selected at once, and value is an array of items
  | with values corresponding to those in the `options` prop.
```

### Summary

The `layout` of a Dash app describes what the app looks like.
The `layout` is a hierarchical tree of components, or a list of components (in Dash 2.17 and later).


 library
 provides classes for all of the HTML
tags and the keyword arguments describe the HTML attributes like `style`, `class`, and `id`.
The `DashCoreComponents`
 library
 generates higher-level components like controls and graphs.
}}

For reference, see:

* <dccLink href="/dash-core-components" children="Dash Core Components overview"/>
* <dccLink href="/dash-html-components" children="Dash HTML Components overview"/>

The next part of the Dash Fundamentals covers how to make these apps interactive.
<dccLink href="/basic-callbacks" children="Dash Fundamentals Part 2: Basic Callbacks"/>
