using Dash 
using OrderedCollections, DataFrames   

moby_dick_text = [
    "Call me Ishmael. ",
    string(
        "Some years ago- never mind how long precisely- having little or no money ",
        "in my purse, and nothing particular to interest me on shore, ",
        "I thought I would sail about a little and see the watery part of the world. ",
    ),
    "It is a way I have of driving off the spleen and regulating the circulation."
]

moby_dick = OrderedDict(
    "Sentence Number" => [i for i in 1:length(moby_dick_text)],
    "Text" => [i for i in moby_dick_text]
)

df = DataFrame(moby_dick)

app = dash()

app.layout = dash_datatable(
    style_data=Dict(
        "whiteSpace" =>  "normal",
    ),
    data = Dict.(pairs.(eachrow(df))),
    columns=[Dict("name" =>c, "id" => c) for c in names(df)],
    css=[Dict(
        "selector" =>  ".dash-spreadsheet td div",
        "rule" =>  """
            line-height :  15px;
            max-height :  30px; min-height :  30px; height :  30px;
            display :  block;
            overflow-y :  hidden;
        """
    )],
    tooltip_data=map(eachrow(df)) do r
      Dict(names(r) .=> string.(values(r)))
    end,
    tooltip_duration=nothing,
    style_cell=Dict("textAlign" =>  "left") # left align text in columns for readability
    
)

run_server(app, "0.0.0.0", debug=true)