using Dash 
using OrderedCollections, DataFrames   

data = OrderedDict([ ("Column $i", collect(1:30)) for i in 1:15 ])

df = DataFrame(data)

app = dash()

app.layout = dash_datatable(
    data = map(eachrow(df)) do r
      Dict(names(r) .=> values(r))
    end,
    columns=[Dict("name" =>c, "id" => c) for c in names(df)],
    fixed_rows=Dict("headers" => true)
)

run_server(app, "0.0.0.0", debug=true)