using Dash 
using Statistics
using OrderedCollections, DataFrames   

data = OrderedDict(
      "Date" => ["2015-01-01", "2015-10-24", "2016-05-10", "2017-01-10", "2018-05-10", "2018-08-15"],
      "Region" => ["Montreal", "Toronto", "New York City", "Miami", "San Francisco", "London"],
      "Temperature" => [1, -20, 3.512, 4, 10423, -441.2],
      "Humidity" => [10, 20, 30, 40, 50, 60],
      "Pressure" => [2, 10924, 3912, -10, 3591.2, 15],
)

df = DataFrame(data) 

app = dash()

nm = names(df)
new_nm = names(df,Number)
df_numeric_columns = df[!,new_nm]
val_quant_5 = [quantile(Array(df_numeric_columns[!,n]), 0.5) for n in names(df_numeric_columns)]
val_quant_1 = [quantile(Array(df_numeric_columns[!,n]), 0.1) for n in names(df_numeric_columns)]


app.layout = dash_datatable(
    data = map(eachrow(df)) do r
      Dict(names(r) .=> values(r))
    end,
    sort_action="native",
    columns=[Dict("name" =>c, "id" => c) for c in names(df) if c!= "id"],
    style_data_conditional=vcat(
      [
          Dict(
              "if" =>  Dict(
                  "filter_query" =>  "{$(new_nm[col])} > $value",
                  "column_id" =>  new_nm[col]
              ),
              "backgroundColor" =>  "#3D9970",
              "color" =>  "white"
              ) for (col, value) in enumerate(val_quant_1)
      ],
      [
          Dict(
              "if" =>  Dict(
                  "filter_query" =>  "{$(new_nm[col])} <= $value",
                  "column_id" =>  new_nm[col]
              ),
              "backgroundColor" =>  "#FF4136",
              "color" =>  "white"
              ) for (col, value) in enumerate(val_quant_5)
      ]
  )
    
)

run_server(app, "0.0.0.0", debug=true)

