using Dash

using CSV, DataFrames 

df_gapminder = CSV.read(download("https://raw.githubusercontent.com/plotly/datasets/master/gapminderDataFiveYear.csv"), DataFrame)
df = df_gapminder[1:500,:]

app = dash()

app.layout =  dash_datatable(
        data=Dict.(pairs.(eachrow(df))),
        sort_action="native",
        columns=[Dict("name" =>c, "id" => c) for c in names(df)],
        style_data_conditional=[Dict(
          "if" =>  Dict("filter_query" =>  "{Date} datestartswith $(string("2015-10"))"),
          "backgroundColor" =>  "#85144b",
          "color" =>  "white"
          )]
    )
 
run_server(app, "0.0.0.0", debug=true)
