using Dash

using CSV, DataFrames   

data_with_none = [
    Dict("Firm" =>  "Acme", "2017" =>  "", "2018" =>  5, "2019" =>  10, "2020" =>  4),
    Dict("Firm" =>  "Olive", "2017" =>  nothing, "2018" =>  3, "2019" =>  13, "2020" =>  3),
    Dict("Firm" =>  "Barnwood", "2017" =>  NaN, "2018" =>  7, "2019" =>  3, "2020" =>  6),
    Dict("Firm" =>  "Henrietta", "2017" =>  14, "2018" =>  1, "2019" =>  13, "2020" =>  1),
]

df = vcat(DataFrame.(data_with_none)...)

df[!,"2017"] = replace(df[!,"2017"], NaN => "N/A")
df[!,"2017"] = replace(df[!,"2017"], missing => "N/A")

app = dash()

app.layout = html_div([
  html_pre(string(df)),
  dash_datatable(
      data=Dict.(pairs.(eachrow(df))),
      columns=[Dict("name" =>c, "id" => c) for c in names(df)],
      style_data_conditional=(
          [
              Dict(
                  "if" =>  Dict(
                      "filter_query" =>  "{$col} = $(string("N/A"))",
                      "column_id" =>  col
                  ),
                  "backgroundColor" =>  "tomato",
                  "color" =>  "white"
              ) for col in names(df)
          ]
      )
  )
])

run_server(app, "0.0.0.0", debug=true)

