using Dash, DashBio, DashBioUtils
using StringEncodings, HTTP, JSON

external_stylesheets = ["https://codepen.io/chriddyp/pen/bWLwgP.css"]

app = dash(external_stylesheets=external_stylesheets)

fasta_str  ="https://git.io/sequence_viewer_P01308.fasta"

seq  = DashBioUtils.read_fasta(fasta_str , is_datafile = false)[1]["sequence"]

app.layout =  html_div([
    dashbio_sequenceviewer(
        id="default-sequence-viewer",
        sequence=seq
    ),
    html_div(id="default-sequence-viewer-output")
])

callback!(app,
    Output("default-sequence-viewer-output", "children"),
    [Input("default-sequence-viewer", "mouseSelection")]
) do value
    if value isa Nothing || length(value) == 0
        return "There is no mouse selection."
    end

    return "The mouse selection is $(value.selection)."
end

run_server(app, "0.0.0.0", debug=true)
