using Dash, DashBio, DashBioUtils

app = dash()

data_path = "https://raw.githubusercontent.com/plotly/datasets/master/Dash_Bio/Molecular/"


app.layout = html_div([
  html_button(id="save-ngl-simg", n_clicks=0, children="Download Image"),
  dcc_input(id="file-ngl-simg", placeholder="Enter filename"),
  dashbio_nglmoleculeviewer(id="download-ngl-simg")
])

callback!(app,
    [Output("download-ngl-simg", "data"),
     Output("download-ngl-simg", "molStyles"),
     Output("download-ngl-simg", "downloadImage"),
     Output("download-ngl-simg", "imageParameters")],
    [Input("save-ngl-simg", "n_clicks")],
    [State("file-ngl-simg", "value")]) do n_clicks, filename

      molstyles_dict = Dict(
        "representations" => ["cartoon", "axes+box"],
        "chosenAtomsColor" => "red",
        "chosenAtomsRadius" => 1,
        "molSpacingXaxis" => 100,
    )
    data_list = [DashBioUtils.get_data(data_path, "1BNA", "red",
                                     reset_view=true, loc=false)]
    imageParameters = Dict(
      "antialias" => true,
      "transparent" => true,
      "trim" => true,
      "defaultFilename" => filename
    )

    downloadImage  = false
    if n_clicks > 0
      downloadImage  = true
    end
    data_list = [DashBioUtils.get_data(data_path, "1BNA", "red", reset_view=true, loc=false)]
    return data_list, molstyles_dict, downloadImage, imageParameters

end

run_server(app, "0.0.0.0", debug=true)