using Dash, DashBio
using StringEncodings, HTTP, JSON

req = HTTP.request("GET", "https://git.io/mol2d_buckminsterfullerene.json")
data = decode(req.body, "UTF-8")

model_data = JSON.parse(data)

app = dash()

for atom in model_data["nodes"]
    atom["atom"] = "N"
end
for bond in model_data["links"]
    bond["distance"] = 50.0
    bond["strength"] = 0.5
end
app.layout = dashbio_molecule2dviewer(
    id="molecule2d-modeldata",
    modelData=model_data
)

run_server(app, "0.0.0.0", debug=true)
