using Dash, DashBio
using StringEncodings, HTTP
using DashHtmlComponents

req = HTTP.request("GET", "https://git.io/alignment_viewer_p53.fasta")
data = decode(req.body, "UTF-8")

app = dash()

app.layout = html_div([
    dashbio_alignmentchart(
          id="alignment-viewer-eventDatum-usage",
        data=data
    ),
    html_p("Hover or click on data to see it here."),
    html_div(id="alignment-viewer-eventDatum-usage-output")
])

callback!(app,
    Output("alignment-viewer-eventDatum-usage-output", "children"),
    [Input("alignment-viewer-eventDatum-usage", "eventDatum")]
) do value
    if value isa Nothing
        return "No data."
    end
    return string(value)
end

run_server(app, "0.0.0.0", debug=true)
