using Dash, Dates

external_stylesheets = ["https://codepen.io/chriddyp/pen/bWLwgP.css"]

app = dash(external_stylesheets=external_stylesheets, suppress_callback_exceptions=true)

app.layout = html_div() do
    dcc_location(id="url"),
    html_div(id="layout-div"),
    html_div(id="content")
end

callback!(
    app,
    Output("content", "children"),
    Input("url", "pathname")
) do pathanme
    html_div([
        dcc_input(id="input", value="hello world"),
        html_div(id="output")
    ])
end

callback!(
    app,
    Output("output", "children"),
    Input("input", "value"),
    prevent_initial_call=true
) do value
    println(">>> update_output")
    value
end

callback!(
    app,
    Output("layout-div", "children"),
    Input("input", "value"),
    prevent_initial_call=true
)  do value
    println(">>> update_layout_div")
    value
end