using DashVtk, PyCall, Dash, DashHtmlComponents
vtkutils = pyimport("dash_vtk.utils")

try
    # VTK 9+
    global imagingcore = pyimport("vtkmodules.vtkImagingCore")
catch
    # VTK =< 8
    global imagingcore = pyimport("vtk.vtkImagingCore")
end

# Use VTK to get some data
data_source = imagingcore.vtkRTAnalyticSource()
data_source.Update()  # <= Execute source to produce an output
dataset = data_source.GetOutput()

# Use helper to get a mesh structure that can be passed as-is to a Mesh
# RTData is the name of the field
mesh_state = vtkutils.to_mesh_state(dataset)

content = vtk_view([
    vtk_geometryrepresentation([
        vtk_mesh(state=mesh_state)
    ]),
]);

# Dash setup
app = dash()

app.layout = html_div(
    style=Dict("width" => "100%", "height" => "400px"),
    children=[content],
);

run_server(app, "0.0.0.0", debug = true)
