---
url: /vtk/structure
name: Structure of Datasets
description: 'Understand the structure of a dataset in Dash VTK.'
languages:
    - python
    - julia
---

# ![](/assets/images/language_icons/julia_50px.svg) Structure of Datasets

In vtk.js because we mostly focus on Rendering we only have 2 types of data structures. We have a `vtkPolyData` that can be used for geometry rendering and a `vtkImageData` that can be used for volume rendering. In proper VTK, we have more types of DataSets and we have several filters that help you convert from one type to another.

Here we explain some of the foundation of those data structures so you could create them by hand if you wanted to.

## vtk_imagedata

An ImageData is an implicit grid that is axis aligned as shown in the picture below.

![vtk_imagedata](/assets/images/vtk/imagedata.jpg)

The set of properties that can be given to `vtk_imagedata` are as follow:
- __origin__: location of the bottom left corner of the grid in the 3D world
- __dimensions__: how many points we have along each axis
- __spacing__: what is the uniform spacing along each axis between the points

A concrete example would be a grid of 5 points or 4 cells along each axis which will go from `[-2, 2]` along each axis.

```julia
vtk_imagedata(
  dimension=[5,5,5],
  origin=[-2,-2,-2],
  spacing=[1,1,1],
)
```


{{example t02_imagedata View full code}}


## vtk_polydata

A vtk_polydata is a surface mesh composed of `points` and `cells`. The cells can be:
- __verts__: Vertex or point to show as a tiny square on the screen
- __lines__: Lines that connect points into a one segment or multi segment line
- __polys__: Polygons which are convex surfaces such as triangles, rectangles, circles...
- __strips__: Triangle strips efficiently combine triangles together with no repeated points just for connectivity

The way cells are defined is via an index-based array that maps to a given point index. For example let's pretend you want to create a line with 2 segments, you will need at least 3 points defined in the `points` array. If those points are defined first in your `points` array, then the `lines` array should be filled as follows:

```julia
nb_points = 3
lines = [nb_points, 0, 1, 2]
```


To create 2 lines independent of each other, you can do it as follows:

```julia
lines = [
  3, 0, 1, 2,        # First line of 2 segments / 3 points
  2, 3, 4,           # Second line of 1 segment / 2 points
  4, 10, 11, 12, 14  # Third line of 3 segments / 4 points
]
```


You can see a concrete example in the image below.


![vtk_polydata](/assets/images/vtk/polydata.jpg)

{{example t03_polydata View full code}}


The `vtk_polydata` element has an additional property to automatically generate cells based on some assumption of the order of the points defined in the `points` array. That property is named __connectivity__ and defaults to `manual`, meaning no automatic action is taken. But that property can be set to `points` to automatically set the vertex to actually see the points provided or `triangles` which uses each set of 3 consecutive points to create a triangle and finally `strips` which consumes all the points in a single strip of triangles.

## Fields

Having a grid is a good start, but most likely you would want to attach a field to a given mesh so you can start looking at it in a 3D context.

Fields are arrays that map to either __Points__ or __Cells__. They could be scalars or vectors of different size.

The diagram below tries to explain the difference between fields located on points vs cells in term of rendering, but it also truly has a different meaning based on the type of data that you have.

![Fields](/assets/images/vtk/fields.jpg)

Caution: By convention, we always attach data to points in an vtk_imagedata for doing VolumeRendering and the array must be registered as scalars.
