using Dash 
using OrderedCollections, DataFrames   

data_election = OrderedDict(
            "Date" =>
            [
                "July 12th, 2013 - July 25th, 2013",
                "July 12th, 2013 - August 25th, 2013",
                "July 12th, 2014 - August 25th, 2014",
            ],
            "Election Polling Organization" =>
            ["The New York Times", "Pew Research", "The Washington Post"],
        
        "Rep" => [1, -20, 3.512],
        "Dem" => [10, 20, 30],
        "Ind" => [2, 10924, 3912],
        
            "Region" =>
            [
                "Northern New York State to the Southern Appalachian Mountains",
                "Canada",
                "Southern Vermont",
            ],
        
)

df = DataFrame(data_election)

app = dash()

dict_data = Dict.(pairs.(eachrow(df)))

app.layout = dash_datatable(
    data= dict_data,
    columns=[Dict("id" =>  c, "name" =>  c) for c in ["shop", "sales", "goal"]],
    tooltip_header=Dict(i =>  i for i in names(df)),

    # Style headers with a dotted underline to indicate a tooltip
    style_header=Dict(
        "textDecoration" =>  "underline",
        "textDecorationStyle" =>  "dotted",
    ),

    # Overflow into ellipsis
    style_cell=Dict(
        "overflow" =>  "hidden",
        "textOverflow" =>  "ellipsis",
        "maxWidth" =>  0,
    ),
    tooltip_delay=0,
    tooltip_duration=nothing
)
run_server(app, "0.0.0.0", debug=true)