using Dash, DashBio, DashBioUtils

app = dash()

data_path = "https://raw.githubusercontent.com/plotly/datasets/master/Dash_Bio/Molecular/"


app.layout = html_div([
    dcc_dropdown(id="ngl-stage-color-dropdown", value="white",
                    options=[Dict("label" => uppercase(s), "value" => s) for s in ["black", "white"]]),
    dcc_dropdown(id="ngl-stage-quality-dropdown", value="low",
                    options=[Dict("label" => uppercase(s), "value" => s) for s in ["auto", "low", "medium", "high"]]),
    dcc_dropdown(id="ngl-stage-camera-dropdown", value="perspective",
                    options=[Dict("label" => uppercase(s), "value" => s)
                            for s in ["perspective", "orthographic"]]),
    dashbio_nglmoleculeviewer(id="ngl-stage"),
])

callback!(app,
    [Output("ngl-stage", "data"),
     Output("ngl-stage", "molStyles"),
     Output("ngl-stage", "stageParameters")],
    [Input("ngl-stage-color-dropdown", "value"),
     Input("ngl-stage-quality-dropdown", "value"),
     Input("ngl-stage-camera-dropdown", "value")]
) do color, quality, camera
    molstyles_dict = Dict(
        "representations" => ["cartoon", "axes+box"],
        "chosenAtomsColor" => "white",
        "chosenAtomsRadius" => 1,
        "molSpacingXaxis" => 100,
    )

    stage_params = Dict(
        "quality" => quality,
        "backgroundColor" => color,
        "cameraType" => camera
    )

    data_list = [DashBioUtils.get_data(data_path, molecule, "red", reset_view=true, loc=false) for molecule in ["1BNA", "PLPR"]]

    return data_list, molstyles_dict, stage_params

end

run_server(app, "0.0.0.0", debug=true)