---
url: /datatable/style
name: Styling
description:
    "`dash_table.DataTable` is an interactive table that supports rich styling,
    conditional formatting, editing, sorting, filtering, and more."
languages:
  - python
  - julia
  - matlab
---

# ![](/assets/images/language_icons/julia_50px.svg) Styling the DataTable

## Default Styles

By default, the DataTable has grey headers and borders
around each cell. It resembles a spreadsheet and the headers are
clearly defined.

{{example defaultStyles}}

## Column Alignment

When displaying numerical data, it's a good practice to use
monospaced fonts, to right-align the data, and to provide the same
number of decimals throughout the column.

> To learn about formatting numbers and dates, see
> <dccLink href="/datatable/typing" children="Typing"/>.

For textual data, left-aligning the text is usually easier to read.

In both cases, the column headers should have the same alignment
as the cell content.

{{example columnAlign}}

## Styling the Table as a List

The gridded view is a good default view for an editable table as it
looks and feels like a spreadsheet.
If your table isn't editable, then in many cases it can look cleaner
without the vertical grid lines.

{{example styleAsList}}

## List Style with Minimal Headers

In some contexts, the grey background can look a little heavy.
You can lighten this up by giving it a white background and
a bold text.

{{example listStyleMinHeaders}}

## Striped Rows

When you're viewing datasets where you need to compare values within
individual rows, it can sometimes be helpful to give the rows
alternating background colors.
We recommend using colors that are faded so as to
not attract too much attention to the stripes.

{{oss {{dash-club}} }}

Notice the three different groups you can style: "cell" is the whole
table, "header" is just the header rows, and "data" is just the data rows.
To use even/odd or other styling based on `row_index` you must use
`style_data_conditional`.

{{example strippedRows}}

## Multi-Headers

Multi-headers are natively supported in the `DataTable`.
Just set `name` inside `columns` as a list of strings instead of a
single string and toggle `merge_duplicate_headers=True`.
`DataTable` will check the neighbors of each header row and, if they
match, will merge them into a single cell automatically.

{{example multiHeaders}}

## Dark Theme with Cells

You have full control over all of the elements in the table.
If you are viewing your table in an app with a dark background,
you can provide inverted background and font colors.

{{example darkThemeCells}}

## Conditional Formatting

See the new <dccLink href="/datatable/conditional-formatting" children="conditional formatting chapter"/>.

## Styles Priority

There is a specific order of priority for the `style_*` properties.
If there are multiple `style_*` props, the one with higher priority will
take precedence. Within each prop, rules for higher indices will be
prioritized over those for lower indices. Previously applied styles of equal
priority win over later ones (applied top to bottom, left to right).

These are the priorities of `style_*` props, in decreasing order:

1. `style_data_conditional`
2. `style_data`
3. `style_filter_conditional`
4. `style_filter`
5. `style_header_conditional`
6. `style_header`
7. `style_cell_conditional`
8. `style_cell`

{{example stylesPriority}}

## Adding Borders

Customize the table borders by adding `border` to `style_*` props.

{{example addingBorders}}

## Styling Editable Columns

Editable columns can be styled using `column_editable` in
`style_header_conditional`, `style_filter_conditional`, and
`style_data_conditional` props.

{{example stylingEditableColumns}}