using Dash

external_stylesheets = ["https://codepen.io/chriddyp/pen/bWLwgP.css"]

app = dash(external_stylesheets=external_stylesheets)

app.layout = html_div([
    dcc_tabs(id="tabs-example", value="tab-1", children=[
        dcc_tab(label="Tab one", value="tab-1"),
        dcc_tab(label="Tab two", value="tab-2"),
    ]),
    html_div(id="tabs-example-content-1")
])

callback!(app,
    Output("tabs-example-content-1", "children"),
    Input("tabs-example", "value")
) do tab
    if tab == "tab-1"
        return html_div([
            html_h3("Tab content 1"),
            dcc_graph(
                id="graph-1-tabs",
                figure=Dict(
                    "data" => [Dict(
                        "x" => [1, 2, 3],
                        "y" => [3, 1, 2],
                        "type" => "bar"
                    )]
                )
            )
        ])
    elseif tab == "tab-2"
        return html_div([
            html_h3("Tab content 2"),
            dcc_graph(
                id="graph-2-tabs",
                figure=Dict(
                    "data" => [Dict(
                        "x" => [1, 2, 3],
                        "y" => [5, 10, 6],
                        "type" => "bar"
                    )]
                )
            )
        ])
    end
end

run_server(app, "0.0.0.0", debug=true)
