---
url: /dash-core-components/store
name: Store
description:
    "dcc.Store is a component for storing JSON-serializable data inside the user's browser."
languages:
    - python
    - julia
    - fsharp
---

# ![](/assets/images/language_icons/julia_50px.svg) dcc.Store

The `dcc.Store` component is used to store JSON data in the browser.

For more information and examples, refer to Part 4 of the Dash tutorial on <dccLink href="/sharing-data-between-callbacks" children="Sharing Data Between Callbacks."/>

## Examples

### Share Data Between Callbacks

{{example_tabs store_share}}


### Store Clicks

{{example_tabs store_clicks}}

## Retrieving the Initial Store Data

If you use the `data` prop as an output, you cannot get the
initial data on load with the `data` prop. To counter this,
you can use the `modified_timestamp` as `Input` and the `data` as `State`.

{{oss {{dash-club}} }}


## Storage Limitations

- The maximum browser [storage space](https://demo.agektmr.com/storage/) is determined by the following factors:
    - Mobile or laptop
    - The browser, under which a sophisticated algorithm is implemented within *Quota Management*
    - Storage encoding where UTF-16 can end up saving only half of the size of UTF-8
    - It's generally safe to store up to 2MB in most environments, and 5~10MB in most desktop-only applications.
- `modified_timestamp` is read only.

***

{{reference dcc.Store}}
