using Dash

app = dash()

app = dash()
app.layout = html_div(
    [
        dcc_input(id="dfalse", type="number", placeholder="Debounce False"),
        dcc_input(
            id="dtrue", type="number",
            debounce=true, placeholder="Debounce True",
        ),
        dcc_input(
            id="input_range", type="number", placeholder="input with range",
            min=10, max=100, step=3,
        ),
        html_hr(),
        html_div(id="number-out"),
    ]
)


callback!(app,
    Output("number-out", "children"),
    Input("dfalse", "value"),
    Input("dtrue", "value"),
    Input("input_range", "value"),
) do fval, tval, rangeval
    return "dfalse: $(string(fval)), dtrue:$(string(tval)), range: $(string(rangeval))"
end

run_server(app, debug = true)
