---
url: /dash-core-components/checklist
name: Checklist
description:
    "The dcc.Checklist component renders a customizable checklist for selecting multiple options, ideal for user input."
languages:
    - python
    - julia
    - fsharp
    - matlab
---

# ![](/assets/images/language_icons/julia_50px.svg) dcc.Checklist

`dcc.Checklist` is a component for rendering a set of checkboxes.
See also <dccLink href="/dash-core-components/radioitems" children="RadioItems"/> for selecting a single
option at a time or <dccLink href="/dash-core-components/dropdown" children="Dropdown"/> for a more compact view.

## Examples

Find a few usage examples below.



### Basic Checklist

To create a basic checklist, provide `options` and a `value` to `dcc.Checklist` in that order.

{{example checklist_vertical}}

### Horizontal Options

Option labels render vertically in the browser by default. 

{{example checklist_horizontal}}

`. There are multiple ways to set `options`. The following examples define the same checklist:

```python
dcc.Checklist(['New York City', 'Montreal', 'San Francisco'], ['Montreal'])
```

```python
dcc.Checklist(
   options=['New York City', 'Montreal', 'San Francisco'],
   value=['Montreal']
)
```

```python
dcc.Checklist(
   options=[
       {'label': 'New York City', 'value': 'New York City'},
       {'label': 'Montreal', 'value': 'Montreal'},
       {'label': 'San Francisco', 'value': 'San Francisco'},
   ],
   value=['Montreal']
)
```

```python
dcc.Checklist(
   options={
        'New York City': 'New York City',
        'Montreal': 'Montreal',
        'San Francisco': 'San Francisco'
   },
   value=['Montreal']
)
```

In these examples, the option's label (what the user sees) and the value (what's passed into the callback) are equivalent. Often it is helpful for these to be separate so that you can easily change the label without changing the callback logic that uses the value:

```
dcc.Checklist(
   options=[
       {'label': 'New York City', 'value': 'NYC'},
       {'label': 'Montreal', 'value': 'MTL'},
       {'label': 'San Francisco', 'value': 'SF'},
   ],
   value=['MTL']
)
```

```
dcc.Checklist(
   options={
        'NYC': 'New York City',
        'MTL': 'Montreal',
        'SF': 'San Francisco'
   },
   value=['MTL']
)
```

>**Note**: Versions of Dash before 2.1 only support keyword arguments for `options` and `value`, and also `options` must be provided as a list of dictionaries.

### Flexible Data Types

We've seen how `options` on a checklist can be set using a list, a dictionary, or a list of dictionaries. `options` also accepts Pandas and NumPy data structures.

In this example, we use the DataFrame's columns (`df.columns`) as the checklist `options`.

{{example dataframe_columns}}

Here, we set `options` with `df.nation.unique()`. This Pandas method returns unique values in the 'nation' column. By passing it to `options`, our checklist displays all unique values in that column.

{{example dataframe_unique}}
}}

### Components as Option Labels

> This feature is available in Dash 2.5 and later.

In previous examples, we've set option labels as strings. You can also use Dash components as option labels.
In this example, each label is a list of components containing an `html.Img` and text in an `html.Span`.

{{example checklist_components_as_props}}

### Styling Components as Option Labels

> This feature is available in Dash 2.5 and later.

You can also style labels by using an `html.Div` component for each label and then setting styles using the `style` property:

{{example checklist_components_as_props_style}}

---

{{reference dcc.Checklist}}
