using Dash, DashBio
using StringEncodings, HTTP

req = HTTP.request("GET", "https://git.io/alignment_viewer_p53.fasta")
data = decode(req.body, "UTF-8")

app = dash()

app.layout = html_div([
    dashbio_alignmentchart(
          id="my-default-alignment-viewer",
        data=data
    ),
    html_div(id="default-alignment-viewer-output")
])

callback!(app,
    Output("default-alignment-viewer-output", "children"),
    [Input("my-default-alignment-viewer", "eventDatum")]
) do value
    if value isa Nothing
        return "No data."
    end
    return string(value)
end

run_server(app, "0.0.0.0", debug=true)
