using Dash, DashHtmlComponents, DashVtk, PyCall
vtkutils = pyimport("dash_vtk.utils")

try
    # VTK 9+
    global imagingcore = pyimport("vtkmodules.vtkImagingCore")
catch
    # VTK =< 8
    global imagingcore = pyimport("vtk.vtkImagingCore")
end

# Use VTK to get some data
data_source = imagingcore.vtkRTAnalyticSource();
data_source.Update()  # <= Execute source to produce an output
dataset = data_source.GetOutput()

# Use helper to get a volume structure that can be passed as-is to a Volume
volume_state = vtkutils.to_volume_state(dataset);  # No need to select field

content = vtk_view([
    vtk_volumerepresentation([
        # GUI to control Volume Rendering
        # + Setup good default at startup
        vtk_volumecontroller(),
        # Actual volume
        vtk_sharedataset([
            vtk_volume(state=volume_state),
        ]),
    ]),
    vtk_slicerepresentation(
        iSlice=10,
        children=[
            vtk_sharedataset(),
        ]
    ),
    vtk_slicerepresentation(
        jSlice=10,
        children=[
            vtk_sharedataset(),
        ]
    ),
    vtk_slicerepresentation(
        kSlice=10,
        children=[
            vtk_sharedataset(),
        ]
    ),
]);

# Dash setup
app = dash()

app.layout = html_div(
    style=Dict("width" => "100%", "height" => "400px"),
    children=[content],
);

run_server(app, "0.0.0.0", debug = true)
