# no-exec-file

using Dash, DashHtmlComponents, DashVtk

filepath = download("https://github.com/plotly/dash-vtk/blob/master/demos/data/cow-nonormals.obj");
txt_content = read(filepath, String);

content = vtk_view([
    vtk_geometryrepresentation([
        vtk_reader(
            vtkClass="vtkOBJReader",
            parseAsText=txt_content,
        ),
    ]),
]);

# Dash setup
app = dash()

app.layout = html_div(
    style=Dict("width" => "100%", "height" => "400px"),
    children=[content],
);

run_server(app, "0.0.0.0", debug = true)
