---
url: /vtk
name: Overview
description: "Dash VTK enables Dash application developers to harness the power of Kitware's open source Visualization Toolkit when manipulating or displaying scientific data."
icon: loop-arrow.svg
languages:
    - python
    - julia
---

# ![](/assets/images/language_icons/julia_50px.svg) Dash VTK

Dash VTK aims to integrate VTK/vtk.js visualization into the Dash framework.

[VTK](https://vtk.org/) stands for _Visualization Toolkit_ and is a popular library written in C++ which is also available in Python for doing data processing and visualization in the scientific and medical fields. Typically VTK is used to visualize 3D geometries from simulations or sensors such as LIDAR scanner. For the medical world, VTK is used to render 3D images (i.e. CT, MRI, ...) by doing volume rendering and/or slicing.

[Vtk.js](https://kitware.github.io/vtk-js/) on the other hand is a subset of VTK that focuses on the rendering aspect of it but in the JavaScript world. Vtk.js takes the same architecture and object decomposition as its big brother VTK/C++ but makes it friendly to use inside your browser.

Dash VTK enables its users to use VTK on the server side for any data processing and provides the infrastructure to push the visualization to the client side for a better experience.
Dash VTK does not require VTK but can seamlessly leverage it for looking at point clouds, a CFD simulation or anything 3D mesh or 3D images related.

## User Guide

<dccLink href="/vtk/intro" children="Intro to 3D Visualization" className="toc--section" style="{'underline': {'margin-top': '30px'}}"/>

Introductory concepts about 3D visualization needed to understand how Dash VTK works.

<dccLink href="/vtk/structure" children="Structure of Datasets" className="toc--section" style="{'underline': {'margin-top': '30px'}}"/>

Understand the structure of a dataset in Dash VTK.

<dccLink href="/vtk/representations" children="Representation Components" className="toc--section" style="{'underline': {'margin-top': '30px'}}"/>

Dash VTK Components needed to generate a representation.

<dccLink href="/vtk/other" children="Other Dash VTK Components" className="toc--section" style="{'underline': {'margin-top': '30px'}}"/>

Dash VTK Components that are not used for building representations.

<dccLink href="/vtk/click-hover" children="Click and Hover Callbacks" className="toc--section" style="{'underline': {'margin-top': '30px'}}"/>

Learn to write callbacks based on user click and hovers.

<dccLink href="/vtk/advanced" children="Advanced Demos" className="toc--section" style="{'underline': {'margin-top': '30px'}}"/>

Demos of more advanced usage of Dash VTK.

<dccLink href="/vtk/reference" children="Reference" className="toc--section" style="{'underline': {'margin-top': '30px'}}"/>

Comprehensive reference of all Dash VTK components.
