using Dash 
using OrderedCollections, DataFrames   

data_election = OrderedDict(
            "Date" =>
            [
                "July 12th, 2013 - July 25th, 2013",
                "July 12th, 2013 - August 25th, 2013",
                "July 12th, 2014 - August 25th, 2014",
            ],
            "Election Polling Organization" =>
            ["The New York Times", "Pew Research", "The Washington Post"],
        
        "Rep" => [1, -20, 3.512],
        "Dem" => [10, 20, 30],
        "Ind" => [2, 10924, 3912],
        
            "Region" =>
            [
                "Northern New York State to the Southern Appalachian Mountains",
                "Canada",
                "Southern Vermont",
            ],
        
)

df = DataFrame(data_election)

app = dash()

app.layout = dash_datatable(
    data = map(eachrow(df)) do r
      Dict(names(r) .=> values(r))
    end,
    columns=[Dict("name" =>c, "id" => c) for c in names(df)],
    css=[Dict("selector" =>  "table", "rule" =>  "table-layout =>  fixed")],
    style_cell=Dict(
        "width" =>  "$(ncol(df))%",
        "textOverflow" =>  "ellipsis",
        "overflow" =>  "hidden"
    )
    
)

run_server(app, "0.0.0.0", debug=true)