using Dash 
using OrderedCollections, DataFrames   

data = OrderedDict(
      "Date" => ["2015-01-01", "2015-10-24", "2016-05-10", "2017-01-10", "2018-05-10", "2018-08-15"],
      "Region" => ["Montreal", "Toronto", "New York City", "Miami", "San Francisco", "London"],
      "Temperature" => [1, -20, 3.512, 4, 10423, -441.2],
      "Humidity" => [10, 20, 30, 40, 50, 60],
      "Pressure" => [2, 10924, 3912, -10, 3591.2, 15],
)

df = DataFrame(data) 

app = dash()

app.layout = dash_datatable(
  columns=[
    Dict("name" =>  ["", "Year"], "id" =>  "year"),
    Dict("name" =>  ["City", "Montreal"], "id" =>  "montreal"),
    Dict("name" =>  ["City", "Toronto"], "id" =>  "toronto"),
    Dict("name" =>  ["City", "Ottawa"], "id" =>  "ottawa"),
    Dict("name" =>  ["City", "Vancouver"], "id" =>  "vancouver"),
    Dict("name" =>  ["Climate", "Temperature"], "id" =>  "temp"),
    Dict("name" =>  ["Climate", "Humidity"], "id" =>  "humidity"),
],
data=[
    Dict(
        "year" =>  i,
        "montreal" =>  i * 10,
        "toronto" =>  i * 100,
        "ottawa" =>  i * -1,
        "vancouver" =>  i * -10,
        "temp" =>  i * -100,
        "humidity" =>  i * 5,
    )
    for i in 1:10
],
merge_duplicate_headers=true,
    
)

run_server(app, "0.0.0.0", debug=true)