using Dash, DashBootstrapComponents
using CSV, DataFrames   

app = dash()

df = CSV.read(download("https://git.io/Juf1t"), DataFrame)

app = dash(external_stylesheets=[dbc_themes.BOOTSTRAP])

app.layout = dbc_container([
    dbc_label("Click a cell in the table:"),
    dash_datatable(
        id="tbl", 
        columns=[Dict("name" =>i, "id" => i) for i in names(df)],
        data = Dict.(pairs.(eachrow(df)))
    ),
    dbc_alert("Click the table", id="tbl_out"),
])

callback!(app,
    Output("tbl_out", "children"), 
    Input("tbl", "active_cell")
) do active_cell
  return string(active_cell)
end

run_server(app, "0.0.0.0", debug=true)