---
url: /dash-core-components/input
name: Input
description:
    "Use the dcc.Input component to create input fields for text, numbers, passwords, and more, allowing dynamic user input."
languages:
    - python
    - julia
    - fsharp
    - matlab
---
# ![](/assets/images/language_icons/f-sharp_50px.svg) dcc.Input


The `dcc.Input` component creates input fields for text, numbers, passwords, and more, allowing dynamic user input.


## Examples

Find a few usage examples below.



### Supported Input Types

{{example input_all_types}}

{{oss {{dash-club}} }}

### Debounce Delays the Input Processing

{{example input-basic}}

### Number Input

Number type is now close to native HTML5 `input` behavior across
browsers. We also apply a strict number casting in callbacks:
valid number converts into corresponding number types, and invalid number
converts into null. E.g.
```fsharp
Input.input "range" [
    Input.Attr.inputType InputType.Number
    Input.Attr.value null
    Input.Attr.min 2; Input.Attr.max 10; Input.Attr.step 1
]
```
type 3 and 11 will return respectively integer three and `null` in F# callbacks.

>**Important Notice re Integer vs Float**:
There is a limitation when converting numbers like 1.0 or 0.0: the
corresponding number type in callbacks is **Integer** instead of **Float**.
Add extra guard casting like `float` within callbacks if needed.

{{example input_number_type}}

------------------------

{{reference dcc.Input}}