open System
open Dash.NET

let dfalse = "dfalse"
let dtrue = "dtrue"
let input_range = "input_range"
let number_out = "number-out"
let outputTarget = number_out @. Children

let layout =
    Html.div [
        Attr.children [
            Input.input dfalse [
                Input.Attr.inputType InputType.Number
                Input.Attr.placeholder "Debounce False"
                Input.Attr.value null
            ]
            Input.input dtrue [
                Input.Attr.inputType InputType.Number
                Input.Attr.placeholder "Debounce True"
                Input.Attr.value null
                Input.Attr.debounce true
            ]
            Input.input input_range [
                Input.Attr.inputType InputType.Number
                Input.Attr.placeholder "input with range"
                Input.Attr.value null
                Input.Attr.min 10; Input.Attr.max 100; Input.Attr.step 3
            ]
            Html.hr []
            Html.div [ Attr.id number_out ]
        ]
    ]

let callback =
    Callback.singleOut (
        [ dfalse @. Value
          dtrue @. Value
          input_range @. Value ],
        outputTarget,
        (fun (fval: Nullable<int>) (tval: Nullable<int>) (rangeval: Nullable<int>) ->
            outputTarget => sprintf "dfalse: %A, dtrue: %A range: %A" fval tval rangeval),
        PreventInitialCall = true
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback
    |> DashApp.run args
