open Dash.NET.Giraffe

open Dash.NET.DCC
open Plotly.NET
open Plotly.NET.LayoutObjects
open FSharp.Data

let [<Literal>] Csv = "https://raw.githubusercontent.com/plotly/datasets/master/iris.csv"
type IrisData = CsvProvider<Csv>
let iris = IrisData.Load(Csv).Cache()
let h = iris.Rows |> Seq.head

let fig =
    Chart.Scatter(
        (iris.Rows |> Seq.map (fun r -> r.SepalWidth)),
        (iris.Rows |> Seq.map (fun r -> r.SepalLength)),
        StyleParam.Mode.Markers
    )
    |> Chart.withXAxis(LinearAxis.init(Title=Title.init (Text=nameof(h.SepalWidth))))
    |> Chart.withYAxis(LinearAxis.init(Title=Title.init (Text=nameof(h.SepalLength))))
    |> GenericChart.toFigure

let layout = Graph.graph "graph" [ Graph.Attr.figure fig ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
