open Dash.NET.Suave
open Dash.NET.DCC
open Dash.NET
open System


let layout =
    Html.div [ Attr.children [ ConfirmDialogProvider.confirmDialogProvider
                                   "danger-danger-provider"
                                   [ ConfirmDialogProvider.Attr.message
                                       "Danger danger! Are you sure you want to continue?"
                                     ConfirmDialogProvider.Attr.children [ Html.button [ Attr.children "Click Me" ] ] ]
                               Html.div [ Attr.id "output-provider" ] ] ]


let callback =
    Callback.singleOut (
        "danger-danger-provider"
        @. CustomProperty "submit_n_clicks",
        "output-provider" @. Children,
        (fun (nClick: int) ->

            let dangerousLabel =
                $"It was dangerous but we did it!
            Submitted {nClick} times"

            let label =
                match nClick with
                | v when v > 0 -> dangerousLabel
                | v -> ""

            "output-provider" @. Children => label
            ))
      


[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback
    |> DashApp.run args