open Dash.NET.Suave
open Dash.NET.DCC
open Dash.NET
open System


let layout =
    Html.div [ Attr.children [ ConfirmDialog.confirmDialog
                                   "confirm-danger"
                                   [ ConfirmDialog.Attr.message "Danger danger! Are you sure you want to continue?" ]
                               Dropdown.dropdown
                                   "dropdown-danger"
                                   [ seq {
                                         "Safe"
                                         "Danger!!"
                                     }
                                     |> Seq.map (fun x -> DropdownOption.init (x, x))
                                     |> Dropdown.Attr.options ]

                               Html.div [ Attr.id "output-danger" ] ] ]


let displayConfirmCallback =
    Callback.singleOut (
        "dropdown-danger" @. Value,
        "confirm-danger" @. CustomProperty "displayed",
        (fun (value: string) ->
            let showDanger =
                match value with
                | "Danger!!" -> true
                | _ -> false

            "confirm-danger" @. CustomProperty "displayed"
            => showDanger)
    )


let confirmDangerCallback =
    Callback.singleOut (
        "confirm-danger" @. CustomProperty "submit_n_clicks",
        "output-danger" @. Children,
        (fun (nClick: int) ->
            let dangerousLabel = $"It wasnt easy but we did it {nClick}"

            let label =
                match nClick with
                | v when v > 0 -> dangerousLabel
                | v -> ""

            "output-danger" @. Children => label)
    )

      


[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.addCallback displayConfirmCallback
    |> DashApp.addCallback confirmDangerCallback
    |> DashApp.run args