---
url: /live-updates
name: Live Updates
description:
    "Update your apps on page load or on a predefined interval (e.g. every 5 seconds)"
icon: loop-arrow.svg
languages:
  - python
  - julia
  - r
  - fsharp
---

# ![](/assets/images/language_icons/f-sharp_50px.svg) Live Updating Components

## The `dcc.Interval` Component

Components in Dash usually update through user interaction like
selecting a dropdown, dragging a slider, or hovering over points.

If you're building an application for monitoring, you may want to update
components in your application every few seconds or minutes.

The `dcc.Interval` element allows you to update components
on a predefined interval. The `n_intervals` property is an integer that is
automatically incremented every time `interval` milliseconds pass.
You can listen to this variable inside your app's `callback` to fire
the callback on a predefined interval.

This example pulls data from live satellite feeds and updates the graph
and the text every second.

```fsharp
open Dash.NET
open System

let dslLayout =
    Html.div [
        Attr.children [
            Html.h1 [ Attr.id "time_display"; Attr.children "The time is:" ]
            Interval.interval "interval_component" [
                Interval.Attr.interval 1000
                Interval.Attr.nIntervals 0
            ]
        ]
    ]

let changeTextCallback =
    Callback.singleOut (
        "interval_component" @. (CustomProperty "n_intervals"),
        "time_display" @. Children,
        fun (nIntervals: int) ->
            "time_display" @. Children => sprintf "The time is: %s" (DateTimeOffset.Now.ToString())
        , PreventInitialCall = false
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout dslLayout
    |> DashApp.addCallback changeTextCallback
    |> DashApp.run args
```


{{oss {{dash-club}} }}





