// Run this app with `dotnet fsi app.fsx` and
// visit http://127.0.0.1:8050/ in your web browser.

#r "nuget: Dash.NET"
#r "nuget: Suave, 2.6.1"
#r "nuget: Suave.Experimental, 2.6.1"
#r "nuget: Dash.NET.Sauve"
#r "nuget: Plotly.NET"
#r "nuget: Feliz.Engine"
#r "nuget: Newtonsoft.Json, 13.0.1"
#r "nuget: FSharp.Data"

open Dash.NET
open Dash.NET.Suave
open FSharp.Data

let maxRows = 10
let csv =
    CsvFile
        .Load("https://gist.githubusercontent.com/chriddyp/c78bf172206ce24f77d6363a2d754b59/raw/c353e8ef842413cae56ae3920b8fd78468aa4cb2/usa-agricultural-exports-2011.csv")
        .Cache()

let layout =
    Html.div [
        Attr.children [
            Html.h4 [ Attr.children "US Agriculture Exports (2011)" ]

            Html.table [
                Attr.children [
                    Html.thead [
                        csv.Headers
                        |> Option.map (Array.map (fun h -> Html.th [ Attr.children h ]))
                        |> Option.defaultValue [||]
                        |> Attr.children
                    ]
                    Html.tbody [
                        Attr.children (
                            csv.Rows
                            |> Seq.take maxRows
                            |> Seq.map (fun r ->
                                Html.tr [
                                    r.Columns
                                    |> Array.map (fun col -> Html.td [ Attr.children col ])
                                    |> Attr.children
                                ]
                            )
                        )
                    ]
                ]
            ]

        ]
    ]

DashApp.initDefault()
|> DashApp.withLayout layout
|> DashApp.run [||]
    { hostname = "localhost";
      ip = "127.0.0.1"
      port = 8050
      errorHandler = Suave.Web.defaultErrorHandler }
