// Run this app with `dotnet fsi app.fsx` and
// visit http://127.0.0.1:8050/ in your web browser.

#r "nuget: Dash.NET"
#r "nuget: Suave, 2.6.1"
#r "nuget: Suave.Experimental, 2.6.1"
#r "nuget: Dash.NET.Sauve"
#r "nuget: Plotly.NET"
#r "nuget: Feliz.Engine"
#r "nuget: Newtonsoft.Json, 13.0.1"

open Plotly.NET
open Dash.NET
open Dash.NET.Suave
open Dash.NET.DCC

let data =
    [ "SF", [ "Apples", 4; "Oranges", 1; "Bananas", 2 ]
      "Montr?al", [ "Apples", 2; "Oranges", 4; "Bananas", 5 ] ]

let fig =
    data
    |> List.map (fun (city, amts) -> Chart.Column(amts |> List.map fst, amts |> List.map snd, Name=city))
    |> Chart.Combine
    |> GenericChart.toFigure

let layout =
    Html.div [
        Attr.children [

            Html.h1 [ Attr.children "Hello Dash" ]

            Html.div [
                Attr.children """
                    Dash: A web application framework for your data.
                """
            ]

            Graph.graph "example-graph" [
                Graph.Attr.figure fig
            ]
        ]
    ]

DashApp.initDefault()
|> DashApp.withLayout layout
|> DashApp.run [||]
    { hostname = "localhost";
      ip = "127.0.0.1"
      port = 8050
      errorHandler = Suave.Web.defaultErrorHandler }
