// Run this app with `dotnet fsi app.fsx` and
// visit http://127.0.0.1:8050/ in your web browser.

#r "nuget: Dash.NET"
#r "nuget: Suave, 2.6.1"
#r "nuget: Suave.Experimental, 2.6.1"
#r "nuget: Dash.NET.Sauve"
#r "nuget: Plotly.NET"
#r "nuget: Feliz.Engine"
#r "nuget: Newtonsoft.Json, 13.0.1"

open Dash.NET
open Dash.NET.Suave
open Dash.NET.DCC

let layout =
    Html.div [
        Attr.children [
            Html.label [ Attr.children "Dropdown" ]
            Dropdown.dropdown "dropdown" [
                Dropdown.Attr.options [
                    { Label = "New York City"; Value = "NYC"; Disabled = false; Title = "New York City" }
                    { Label = "Montréal"; Value = "MTL"; Disabled = false; Title = "Montréal" }
                    { Label = "San Francisco"; Value = "SF"; Disabled = false; Title = "San Francisco" }
                ]
                Dropdown.Attr.value "MTL"
            ]

            Html.label [ Attr.children "Multi-Select Dropdown" ]
            Dropdown.dropdown "multi-select-dropdown" [
                Dropdown.Attr.options [
                    { Label = "New York City"; Value = "NYC"; Disabled = false; Title = "New York City" }
                    { Label = "Montréal"; Value = "MTL"; Disabled = false; Title = "Montréal" }
                    { Label = "San Francisco"; Value = "SF"; Disabled = false; Title = "San Francisco" }
                ]
                Dropdown.Attr.value "MTL"
                Dropdown.Attr.multi true
            ]

            Html.label [ Attr.children "Radio Items" ]
            RadioItems.radioItems "radioitems" [
                RadioItems.Attr.options [
                    { Label = "New York City"; Value = "NYC"; Disabled = false }
                    { Label = "Montréal"; Value = "MTL"; Disabled = false }
                    { Label = "San Francisco"; Value = "SF"; Disabled = false }
                ]
                RadioItems.Attr.value "MTL"
            ]

            Html.label [ Attr.children "Checkboxes" ]
            Checklist.checklist "checkboxes" [
                Checklist.Attr.options [
                    { Label = "New York City"; Value = "NYC"; Disabled = false }
                    { Label = "Montréal"; Value = "MTL"; Disabled = false }
                    { Label = "San Francisco"; Value = "SF"; Disabled = false }
                ]
                Checklist.Attr.value [ "MTL"; "SF" ]
            ]

            Html.label [ Attr.children "Text Input" ]
            Input.input "text-input" [
                Input.Attr.inputType InputType.Text
                Input.Attr.value "MTL"
            ]

            Html.label [ Attr.children "Slider" ]
            Slider.slider "slider" [
                Slider.Attr.min 0
                Slider.Attr.max 9
                Slider.Attr.marks
                    ([ for i in 1..5 ->
                        string i,
                        Slider.MarkValue.String <| match i with 1 -> sprintf "Label %i" i | _ -> string i ]
                     |> Map.ofList
                     |> Slider.MarksType)
                Slider.Attr.value 5
            ]
        ]
        Attr.style [ StyleProperty ("columnCount", "2") ]
    ]

DashApp.initDefault()
|> DashApp.withLayout layout
|> DashApp.run [||]
    { hostname = "localhost";
      ip = "127.0.0.1"
      port = 8050
      errorHandler = Suave.Web.defaultErrorHandler }
