open Dash.NET.Giraffe
open Dash.NET.DashTable

let columns = [|
    DataTable.Column.init("Default", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.init())
    DataTable.Column.init("Negative", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper(sign=Negative))
    DataTable.Column.init("Positive", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper(sign=Positive))
    DataTable.Column.init("Parentheses", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper().sign(Parantheses))
    DataTable.Column.init("Percentage/Parentheses", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper(scheme=Percentage, precision=2u, sign=Parantheses))
    DataTable.Column.init("Custom", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.init(specifier="("))
|]

let values = [
    123.1; 123.12; 1234.123; 12345.12;
    -123.1; -123.12; -1234.123; -12345.12
]

let layout =
    DataTable.dataTable "datatable" [
        DataTable.Attr.columns columns
        DataTable.Attr.data (values |> List.map (fun v -> box {| a = v |}))
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
