open Dash.NET.Giraffe
open Dash.NET.DashTable

let columns = [|
    DataTable.Column.init("No fill", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.init())
    DataTable.Column.init("Align left (10)", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper().align(Left).fill('-').paddingWidth(10u))
    DataTable.Column.init("Align right (8)", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.helper(align=Right, fill='-', paddingWidth=8u))
    DataTable.Column.init("Align center (6)", "a", columnType=DataTable.ColumnType.Numeric,
                    format=Format.init(specifier="-^6"))
|]

let values = [ 123; 123; 1234; 12345; 123456789 ]

let layout =
    DataTable.dataTable "datatable" [
        DataTable.Attr.columns columns
        DataTable.Attr.data (values |> List.map (fun v -> box {| a = v |}))
    ]

[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
