---
url: /dash-core-components/location
name: Location
description: "The dcc.Location is a component that represents the browser's address bar, managing URL pathname and search for multi-page apps and navigation."
languages:
  - python
  - julia
  - matlab
  - fsharp
---

# ![](/assets/images/language_icons/f-sharp_50px.svg) dcc.Location

The `dcc.Location` component represents the location or address bar in your web
browser. Through its `Location.Attr.href`, `Location.Attr.pathname`, `Location.Attr.search` and `Location.Attr.hash` properties
you can access different portions of the URL that the app is loaded on.

See the <dccLink href="/urls" children="URLs & Multipage Apps chapter"/> for more details.

For example, given the URL `http://127.0.0.1:8050/page-2?a=test#quiz`:

- `Location.Attr.href` = `"http://127.0.0.1:8050/page-2?a=test#quiz"`
- `Location.Attr.pathname` = `"/page-2"`
- `Location.Attr.search` = `"?a=test"`
- `Location.Attr.hash` = `"#quiz"`

***

{{reference dcc.Location}}
